import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import javax.microedition.io.*;
import java.io.*;
import org.kxml.*;
import org.kxml.parser.*;

public class testkXMLSAX
       extends MIDlet implements CommandListener {

  // La commande de sortie
  private Command exitCommand; 
  private Command xmlGetCommand;
  private Command xmlPostCommand;
  // Le display pour ce MIDlet
  private Display display;

  private final static String SERVLET_URL = "http://127.0.0.1:8080/servlets/ServletXML";
  private static TextBox t;
  private static String textBoxString = "";

  public testkXMLSAX () {
    display = Display.getDisplay(this);
    exitCommand = new Command ("Sortie", Command.EXIT, 2);
    xmlGetCommand = new Command ("Get", Command.SCREEN, 1);
    xmlPostCommand = new Command ("Post", Command.SCREEN,1);
  }

  public void startApp() {
    t = new TextBox("MIDlet XML SAX", "", 256, 0);
    t.addCommand (exitCommand);
    t.addCommand (xmlGetCommand);
    t.addCommand (xmlPostCommand);
    t.setCommandListener (this);
    display.setCurrent (t);
  }

  public void pauseApp() {
  }

  public void destroyApp (boolean unconditional) {
  }

  public void commandAction (Command c, Displayable s) {
    if (c == exitCommand) {
      destroyApp(true);
      notifyDestroyed();
    } else if (c == xmlPostCommand) {
      try {
        doMIDPPost();
      } catch (IOException ioe) {
      } 
    } else if (c == xmlGetCommand) {
      try {
        String xmlString = getXML();
        byte[] xmlByteArray = xmlString.getBytes();
        ByteArrayInputStream xmlStream = new ByteArrayInputStream (xmlByteArray);
        InputStreamReader xmlReader = new InputStreamReader (xmlStream);
        XmlParser parser = new XmlParser (xmlReader);
        traverse (parser, "");
      } catch (Exception e) {
        e.printStackTrace();
      }
    }
  }

  public void doMIDPPost() throws IOException {
    InputStream is = null;
    OutputStream os = null;
    HttpConnection conn = null;
    int ch;
    try {
      StringBuffer buffer = new StringBuffer();
      conn = (HttpConnection)Connector.open (SERVLET_URL);
      // Envoie les paramtres  la servlet via la mthode POST
      conn.setRequestMethod (HttpConnection.POST);
      conn.setRequestProperty ("ticker", "SUNW");
      conn.setRequestProperty ("valeur", "20");
      conn.setRequestProperty ("societe", "Sun Microsystems");
      os = conn.openOutputStream();
      os.flush();
      is = conn.openDataInputStream();
      while ((ch = is.read()) != -1) buffer.append ((char)ch);
      String resultString = buffer.toString();
      if (is != null) is.close();
      if (conn != null) conn.close();
      if (os != null) os.close();
      System.out.println ("Rsultats : " + resultString);
    } catch (IOException e) {
    }
  }

  public String getXML() throws IOException {
    HttpConnection conn = null;
    InputStream servletStream = null;
    OutputStream os = null;
    StringBuffer xmlBuffer = new StringBuffer();
    String xmlString = null;
    try {
      conn = (HttpConnection)Connector.open (SERVLET_URL);
      conn.setRequestMethod (HttpConnection.GET);
      os = conn.openOutputStream();
      os.flush();
      servletStream = conn.openDataInputStream();
      int ch;
      while ((ch = servletStream.read()) != -1)
        xmlBuffer.append((char)ch);
      xmlString = xmlBuffer.toString();
      if (servletStream != null) servletStream.close();
      if (conn != null) conn.close();
      if (os != null) os.close();
      System.out.println ("Instructions : " + xmlString);
    } catch (IOException e) {
    }
    return xmlString;
  }

  // Traverse le fichier XML
  public static void traverse (XmlParser parser, String indent)
         throws IOException {
    boolean leave = false;
    String st = new String();
    do {
      ParseEvent event = parser.read ();
      switch (event.getType()) {
        case Xml.START_TAG:
          st = indent + "start_tag: " + event.getName() + "; attributs: " + event.getAttributes();
          System.out.println (st);
          textBoxString += st;
          traverse (parser, indent + ".");
          break;
        case Xml.END_TAG:
          st = indent + "/end_tag: " + event.getName();
          textBoxString += st;
          leave = true;
          break;
        case Xml.END_DOCUMENT:
          st = indent + "Fin du document atteinte";
          textBoxString += st;
          leave = true;
          break;
        case Xml.TEXT:
          st = indent + "texte: " + event.getText();
          textBoxString += st;
          break;
        case Xml.WHITESPACE:
          break;
        default:
      }
    } while (!leave);
    t.setString (textBoxString);
  }
}
